#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Raymarch template GGXMod01.fsh   by   darkeclipz
//https://www.shadertoy.com/view/3tyyWm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// https://iquilezles.org/articles/smin
float smin(float a, float b, float k) {
    float h = max(k-abs(a-b), 0.0)/k;
    return min(a, b) - h*h*h*k*(1.0/6.0);
}

float sdSphere(in vec3 p, float r) {
    return length(p) - r;
}

mat2 rot(float a) {
    float c = cos(a), s = sin(a);
    return mat2(c, -s, s, c);
}

float map(in vec3 p) {
    
    // Add your SDF's here: also remove line 87.

    p = mod(p, 2.0) - 1.0; // Domain repetition    
    
    float sphere = sdSphere(p, 0.4);
    float ears = sdSphere(abs(p) - vec3(.25, .25, 0), 0.25);
    return smin(sphere, ears, 0.08);
}

#define MIN_MARCH_DIST 0.001
#define MAX_MARCH_DIST 60.
#define MAX_MARCH_STEPS 100.
float march(in vec3 ro, in vec3 rd) {
    float t = 0., 
          i = 0.;
    for(i=0.; i < MAX_MARCH_STEPS; i++) {
        vec3 p = ro + t*rd;
        float d = map(p);
        if(d < MIN_MARCH_DIST)
            break;
        t += d;
        if(t > MAX_MARCH_DIST)
            break;
    }
    if(i >= MAX_MARCH_STEPS) {
        t = MAX_MARCH_DIST;
    }
    return t;
}

vec3 normal(in vec3 p) {
    float eps = MIN_MARCH_DIST;
    vec2 h = vec2(eps, 0);
    return normalize(vec3(map(p+h.xyy) - map(p-h.xyy),
                          map(p+h.yxy) - map(p-h.yxy),
                          map(p+h.yyx) - map(p-h.yyx)));
}

float G1V(float dotNV, float k) {
    return 1.0 / (dotNV * (1.0 - k) + k);
}

// http://filmicworlds.com/blog/optimizing-ggx-shaders-with-dotlh/
float brdf_ggx(vec3 N, vec3 V, vec3 L, float roughness, float F0) {
    float alpha = roughness * roughness;
    vec3 H = normalize(V+L);
    float dotNL = clamp(dot(N,L), 0., 1.);
    float dotNV = clamp(dot(N,V), 0., 1.);
    float dotNH = clamp(dot(N,H), 0., 1.);
    float dotLH = clamp(dot(L,H), 0., 1.);
    float alphaSqr = alpha*alpha;
    float pi = 3.14159;
    float denom = dotNH * dotNH * (alphaSqr - 1.0) + 1.0;
    float D = alphaSqr / (pi * denom * denom);
    float dotLH5 = pow(1.0 - dotLH, 5.0);
    float F = F0 + (1.0 - F0) * dotLH5;
    float k = alpha / 2.0;
    float vis = G1V(dotNL, k) * G1V(dotNV, k);
    return dotNL * D * F * vis;
}

vec3 shade(vec3 N, vec3 L, vec3 V, vec3 diffuse, vec3 specular) {
    return diffuse * clamp(dot(L, N), 0., 1.)       // Lambertian Diffuse
         + specular * brdf_ggx(N, V, L, 0.55, 0.1); // GGX Specular
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - 0.5*iResolution.xy)/iResolution.y;
    
    // Camera
    
    
    
    
    vec3 ro = vec3(0,0,-1.);
    vec3 ta = vec3(0,0,0);
    vec3 ww = normalize(ta-ro);
    vec3 uu = normalize(cross(ww, vec3(0,1,0)));
    vec3 vv = normalize(cross(uu,ww));
    vec3 rd = normalize(uv.x*uu + uv.y*vv + 1.0*ww);
    ro.z += iTime;
    
    // March
    float t = march(ro, rd);
    
    // Shade
    vec3 col = vec3(0);
    if(t < MAX_MARCH_DIST) {
        vec3 P = ro + t*rd;                 // Intersection point P.
        vec3 N = normal(P);                 // Normal to the surface.
        vec3 L = normalize(vec3(0, 0, -1)); // Vector from P to light source.
        vec3 V = normalize(ro - P);         // View vector, from P to camera.
        vec3 ambient = vec3(0.00);
        vec3 diffuse = vec3(64./255., 64./255., 4.0);
        vec3 specular = vec3(.8, .8, 1.0);
        col = shade(N, normalize(vec3(1, 0, -1)), V, diffuse, specular)  // Light 1
            + shade(N, normalize(vec3(-5, 2, 1)), V, diffuse, specular)  // Light 2
            + ambient;                                                   // Ambient light
        col *= clamp(exp(-0.20*t + 0.4), 0., 1.);                        // Fog
    }
    
    fragColor = vec4(pow(col, 1.0/vec3(2.2)),1.0); // Gamma correction
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

